<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'forum', language 'es_mx', version '3.10'.
 *
 * @package     forum
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actionsforgraderinterface'] = 'Acciones para la interfaz del valorador';
$string['actionsforpost'] = 'Acciones por publicar';
$string['activityoverview'] = 'Hay nuevas publicaciones en foro';
$string['addanewdiscussion'] = 'Añadir un nuevo tópico/tema de discusión aquí';
$string['addanewquestion'] = 'Añadir una nueva pregunta';
$string['addanewtopic'] = 'Añadir un nuevo tópico/tema';
$string['addtofavourites'] = 'Marcar con estrella esta discusión';
$string['advancedsearch'] = 'Búsqueda avanzada';
$string['alldiscussions'] = 'Todas las discusiones';
$string['allforums'] = 'Todos los foros';
$string['allowdiscussions'] = '¿Puede un  {$a} publicar en este foro?';
$string['allowsallsubscribe'] = 'Este foro permite que cualquiera elija suscribirse o no';
$string['allowsdiscussions'] = 'Este foro permite que cada persona pueda iniciar un tópico/tema de discusión.';
$string['allsubscribe'] = 'Suscribir a todos los foros';
$string['allunsubscribe'] = 'Dar de baja (des-suscribir) de todos los foros';
$string['allusers'] = 'Todos los usuarios';
$string['alreadyfirstpost'] = 'Este ya es el primer mensaje de la discusión';
$string['anyfile'] = 'Cualquier archivo';
$string['areaattachment'] = 'Archivos adjuntos';
$string['areapost'] = 'Mensajes';
$string['attachment'] = 'Archivo adjunto';
$string['attachment_help'] = 'Si lo desea, puede adjuntar uno o más archivos a un mensaje en el foro. Si adjunta una imagen, se mostrará al final del mensaje.';
$string['attachmentname'] = 'Anexo {$a}';
$string['attachmentnameandfilesize'] = '{$a->name} ({$a->size})';
$string['attachmentnopost'] = 'No puede exportar archivos adjuntos sin una id de mensaje';
$string['attachments'] = 'Archivos adjuntos';
$string['attachmentswordcount'] = 'Anexos y conteo de palabras';
$string['authorreplyingprivatelytoauthor'] = '{$a->respondant} contestando de manera privada a {$a->author}';
$string['authorreplyingtoauthor'] = '{$a->respondant} contestando ao {$a->author}';
$string['availability'] = 'Disponibilidad';
$string['blockafter'] = 'Umbral de mensajes para bloqueo';
$string['blockafter_help'] = 'Este ajuste especifica el número máximo de aportaciones que un usuario puede publicar en el período de tiempo especificado. Los usuarios con la capacidad \'mod/forum:postwithoutthrottling\'  están exentos de esta limitación.';
$string['blockperiod'] = 'Período de tiempo para bloqueo';
$string['blockperiod_help'] = 'Se puede impedir que los estudiantes puedan publicar más aportaciones que las especificadas por número determinado dentro de un período de tiempo.
Los usuarios con la capacidad \'moodle/forum:ostwithoutthrottling\' están exentos de esta limitación.';
$string['blockperioddisabled'] = 'No bloquear';
$string['blogforum'] = 'Foro estándar que aparece en un formato similar a blog.';
$string['bynameondate'] = 'de {$a->name} - {$a->date}';
$string['cachedef_forum_is_tracked'] = 'Estado de seguimiento de foro para usuario';
$string['calendardue'] = '{$a} está pendiente';
$string['cancelreply'] = 'Cancelar respuesta';
$string['cannotadd'] = 'No se ha podido añadir la discusión a este foro';
$string['cannotadddiscussion'] = 'Para agregar discusiones a este foro se requiere pertenecer al grupo.';
$string['cannotadddiscussionall'] = 'No tiene permiso para añadir un nuevo tópico/tema de discusión para todos los participantes.';
$string['cannotadddiscussiongroup'] = 'Usted no puede crear una discusión porque Usted no es un miembro de ningún grupo.';
$string['cannotaddsubscriber'] = 'No se pudo añadir un suscriptor con la id {$a} a este foro.';
$string['cannotaddteacherforumto'] = 'No se ha podido convertir la instancia de foro de profesores a la sección 0 del curso';
$string['cannotcreatediscussion'] = 'No se pudo crear una discusión nueva';
$string['cannotcreateinstanceforteacher'] = 'No se pudo crear una nueva instancia de módulo de curso para el foro de profesores';
$string['cannotdeletediscussioninsinglediscussion'] = 'Usted no puede eliminar la primera publicación en una sola discusión';
$string['cannotdeletepost'] = 'No puede eliminar este mensaje.';
$string['cannoteditposts'] = 'No puede eliminar los mensajes de otras personas.';
$string['cannotexportforum'] = 'Usted no puede exportar este foro';
$string['cannotfavourite'] = 'Lo sentimos, pero Usted no tiene permiso para iniciar discusiones.';
$string['cannotfinddiscussion'] = 'No se pudo encontrar la discusión en este foro';
$string['cannotfindfirstpost'] = 'No se pudo encontrar el primer mensaje en este foro';
$string['cannotfindorcreateforum'] = 'No se pudo encontrar o crear un foro principal de anuncios para el sitio';
$string['cannotfindparentpost'] = 'No se pudo encontrar la categoría padre del mensaje {$a}';
$string['cannotmovefromsingleforum'] = 'No se puede mover la discusión a partir de un foro de discusión única';
$string['cannotmovenotvisible'] = 'Foro no visible';
$string['cannotmovetonotexist'] = 'No puede mover nada a ese foro, no existe';
$string['cannotmovetonotfound'] = 'Foro de destino no encontrado en este curso.';
$string['cannotmovetosingleforum'] = 'No se puede mover la discución hacia un foro de discusión única.';
$string['cannotpindiscussions'] = 'Lo sentimos, pero Usted no tiene permiso para fijar discusiones.';
$string['cannotpurgecachedrss'] = 'No se han podido purgar los canales RSS en caché en los foros de partida y de destino: compruebe sus permisos';
$string['cannotremovesubscriber'] = 'No se pudo eliminar al suscriptor con id {$a} de este foro.';
$string['cannotreply'] = 'Usted no puede contestar (réplica) a este mensaje';
$string['cannotsplit'] = 'Las discusiones en este foro no pueden separarse';
$string['cannotsubscribe'] = 'Lo sentimos, debe ser un miembro de un grupo para suscribirse.';
$string['cannottrack'] = 'No se pudo parar de rastrear ese foro';
$string['cannotunsubscribe'] = 'No se pudo darle de baja en ese foro';
$string['cannotupdatepost'] = 'No puede actualizar este mensaje';
$string['cannotviewpostyet'] = 'No puede leer las preguntas de otros estudiantes en esta discusión porque usted aún no ha enviado mensajes';
$string['cannotviewusersposts'] = 'No hay aportaciones realizadas por este usuario que usted pueda ver.';
$string['cleanreadtime'] = 'Hora para marcar mensajes antiguos como leídos';
$string['clicktofavourite'] = 'Usted no ha destacado esta discusión. Clic para destacarlo.';
$string['clicktolockdiscussion'] = 'Clic para bloquear discusiones';
$string['clicktosubscribe'] = 'Usted no está suscrito a esta discusión. Haga clic para suscribirse.';
$string['clicktounfavourite'] = 'Usted ha destacado esta discusión. Clic para quitarle lo destacado.';
$string['clicktounlockdiscussion'] = 'Clic para desbloquear discusiones';
$string['clicktounsubscribe'] = 'Usted está suscrito a esta discusión. Haga clic para des-suscribirse.';
$string['close'] = 'Cerrar';
$string['closegrader'] = 'Cerrar valorador';
$string['completiondiscussions'] = 'El estudiante debe crear discusiones:';
$string['completiondiscussionsdesc'] = 'El estudiante debe crear al menos {$a} discusión(es)';
$string['completiondiscussionsgroup'] = 'Requerir discusiones';
$string['completiondiscussionshelp'] = 'se requieren discusiones para completar';
$string['completionposts'] = 'El estudiante debe enviar discusiones o responderlas:';
$string['completionpostsdesc'] = 'El estudiante debe publicar al menos {$a} discusión(es) o respuesta(s)';
$string['completionpostsgroup'] = 'Requerir mensajes';
$string['completionpostshelp'] = 'requiriendo discusiones o respuestas para completar';
$string['completionreplies'] = 'El usuario debe enviar réplicas:';
$string['completionrepliesdesc'] = 'El estudiante debe publicar al menos {$a} respuesta(s)';
$string['completionrepliesgroup'] = 'Requerir réplicas';
$string['completionreplieshelp'] = 'se requieren réplicas para completar';
$string['configcleanreadtime'] = 'Hora del día para limpiar mensajes antiguos de la tabla de lectura.';
$string['configdigestmailtime'] = 'Se enviará un resumen de los correos a las personas que eligen dicha opción. Este ajuste controla a qué hora del día se enviará el correo (por medio del primer cron que se ejecute después de la hora fijada).';
$string['configdisplaymode'] = 'El modo de visualización por defecto para discusiones si no se ha configurado algún modo.';
$string['configenablerssfeeds'] = 'Esta opción habilita la posibilidad de canales RSS para todos los foros. Aún así necesitará activar manualmente los canales en los ajustes de cada foro.';
$string['configenabletimedposts'] = 'Seleccione \'sí\' si desea permitir el ajuste de períodos en los que se mostrará una nueva discusión en el foro .';
$string['configlongpost'] = 'Cualquier mensaje que exceda esta extensión (sin incluir código HTML) se considera largo. Los mensajes mostrados en la portada del sitio, en las páginas de los cursos con formato social o en los perfiles de usuario, están recortados a una rotura natural en algún sitio entre los valores de forum_shortpost y forum_longpost';
$string['configmanydiscussions'] = 'Número máximo de discusiones a mostrar por página en un foro';
$string['configmaxattachments'] = 'Máximo número de archivos adjuntos que se permiten por mensaje.';
$string['configmaxbytes'] = 'Tamaño máximo por defecto para los archivos adjuntos a los mensajes de los foros en este sitio (sujeto a los límites del curso y otras configuraciones del servidor)';
$string['configoldpostdays'] = 'Número de días para que un mensaje se considere leído.';
$string['configreplytouser'] = 'Cuando un mensaje del foro es enviado por correo electrónico, ¿debería contener la dirección del usuario de modo que los receptores pudieran responderle personalmente en lugar de hacerlo en el foro? Incluso aunque se seleccione \'Sí\', los usuarios pueden elegir en su perfil que su dirección de correo electrónico se mantenga en secreto.';
$string['configrssarticlesdefault'] = 'Si se habilitan los canales RSS, configura el número de artículos por defecto (sean discusiones o publicaciones).';
$string['configrsstypedefault'] = 'Si se habilitan los canales RSS, configura el tipo de actividad por defecto.';
$string['configshortpost'] = 'Cualquier mensaje que no alcance esta extensión (sin incluir código HTML) se considera corto.';
$string['configsubscriptiontype'] = 'Configuración por defecto para modo de suscripción.';
$string['configtrackingtype'] = 'Configuración por defecto para seguimiento de lectura';
$string['configtrackreadposts'] = 'Seleccione \'Sí\' si desea rastrear leído/no leído para cada usuario.';
$string['configusermarksread'] = 'Si elige \'sí\' el usuario debe marcar manualmente un mensaje como leído. Si elige \'no\', cuando el mensaje sea visto se marcará como leído.';
$string['confirmsubscribe'] = '¿Está seguro que quiere suscribirse al foro \'{$a}\'?';
$string['confirmsubscribediscussion'] = '¿Realmente quiere suscribirse a la discusión \'{$a->discussion}\' en el foro \'{$a->forum}\'?';
$string['confirmunsubscribe'] = '¿Está seguro que quiere darse de baja del foro \'{$a}\'?';
$string['confirmunsubscribediscussion'] = '¿Realmente quiere des-suscribirse a la discusión \'{$a->discussion}\' en el foro \'{$a->forum}\'?';
$string['couldnotadd'] = 'No se puede colocar su mensaje debido a un problema desconocido.';
$string['couldnotdeletereplies'] = 'Lo sentimos, no podemos borrar este mensaje debido a que tiene réplicas.';
$string['couldnotupdate'] = 'No se ha podido actualizar su mensaje debido a un error desconocido.';
$string['created'] = 'Creado';
$string['crontask'] = 'Trabajos de mantenimiento y correos de foros';
$string['cutoffdate'] = 'Fecha límite';
$string['cutoffdate_help'] = 'Si se configura, el foro no aceptará publicaciones después de esta fecha.';
$string['cutoffdatereached'] = 'La fecha límite para publicar a este foro se ha alcanzado, por lo que Usted ya no puede publicar en él.';
$string['cutoffdatevalidation'] = 'La fecha límite no puede ser anterior a la fecha de entrega.';
$string['delete'] = 'Eliminar';
$string['deleteddiscussion'] = 'El tópico/tema de discusión se ha borrado';
$string['deletedpost'] = 'El mensaje se ha borrado';
$string['deletedposts'] = 'Los mensajes han sido borrados';
$string['deleteduser'] = 'Usuario eliminado';
$string['deletesure'] = '¿Está seguro de que desea borrar este mensaje?';
$string['deletesureplural'] = '¿Está seguro de que desea borrar este mensaje y todas las réplicas? ({$a} mensajes)';
$string['digestmailheader'] = 'Éste es su resumen diario  de los nuevos mensajes de los foros de {$a->sitename}. Si desea cambiar sus preferencias de foro por correo, vaya a {$a->userprefs}.';
$string['digestmailpost'] = 'Cambie sus preferencias de resúmenes de foros';
$string['digestmailpostlink'] = 'Cambiar sus preferenciasd de resumen del foro: {$a}';
$string['digestmailprefs'] = 'su perfil de usuario';
$string['digestmailsubject'] = 'Resumen diario del foro de {$a}';
$string['digestmailtime'] = 'Hora para enviar resumen de los mensajes';
$string['digestsentusers'] = 'Resúmenes de correo enviados con éxito a {$a} usuarios.';
$string['disallowsubscribe'] = 'No se permiten suscripciones';
$string['disallowsubscribeteacher'] = 'No se permiten suscripciones (excepto para profesores)';
$string['disallowsubscription'] = 'Suscripción';
$string['disallowsubscription_help'] = 'Este foro ha sido configurado de forma tal que Usted no puede des-suscribirse a las discusiones.';
$string['discussion'] = 'Discusión';
$string['discussionlistsortbycreatedasc'] = 'Ordenar por la fecha de creación en orden ascendente';
$string['discussionlistsortbycreateddesc'] = 'Ordenar por la fecha de creación en orden descendente';
$string['discussionlistsortbydiscussionasc'] = 'Ordenar por nombre de discusión en orden ascendente';
$string['discussionlistsortbydiscussiondesc'] = 'Ordenar por nombre de discusión en orden descendente';
$string['discussionlistsortbygroupasc'] = 'Ordenar por grupo en orden ascendente';
$string['discussionlistsortbygroupdesc'] = 'Ordenar por grupo en orden descendente';
$string['discussionlistsortbylastpostasc'] = 'Ordenar  por la fecha de creación de la última publicación en orden ascendente';
$string['discussionlistsortbylastpostdesc'] = 'Ordenar por la fecha de creación de la última publicación en orden descendente';
$string['discussionlistsortbyrepliesasc'] = 'Ordenar por el número de respuestas en orden ascendente';
$string['discussionlistsortbyrepliesdesc'] = 'Ordenar por el número de respuestas en orden descendente';
$string['discussionlistsortbystarterasc'] = 'Ordenar por nombre de quien inició la discusión en orden ascendente';
$string['discussionlistsortbystarterdesc'] = 'Ordenar por nombre de quien inició la discusión en orden descendente';
$string['discussionlocked'] = 'Esta discusión ha sido bloqueada, por lo que Usted ya no puede responder a ella.';
$string['discussionlockingdisabled'] = 'No bloquear discusiones';
$string['discussionlockingheader'] = 'Bloqueo de discusión';
$string['discussionmoved'] = 'Esta discusión se ha movido a \'{$a}\'.';
$string['discussionmovedpost'] = 'Esta discusión se ha movido a <a href="{$a->discusshref}">aquí</a> en el foro <a href="{$a->forumhref}">{$a->forumname}</a>';
$string['discussionname'] = 'Nombre de la discusión';
$string['discussionnownotsubscribed'] = '{$a->name} NO será notificado acerca de nuevas publicaciones en \'{$a->discussion}\' de \'{$a->forum}\'';
$string['discussionnowsubscribed'] = '{$a->name} será notificado acerca de nuevas publicaciones en \'{$a->discussion}\' de \'{$a->forum}\'';
$string['discussionpin'] = 'Fijar';
$string['discussionpinned'] = 'Fijada';
$string['discussionpinned_help'] = 'Las discusiones fijadas aparecerán en la parte superior de un foro.';
$string['discussions'] = 'Discusiones';
$string['discussionsplit'] = 'La discusión ha sido separada';
$string['discussionsstartedby'] = 'Discusiones comenzadas por {$a}';
$string['discussionsstartedbyrecent'] = 'Discusión recientemente comenzada por {$a}';
$string['discussionsstartedbyuserincourse'] = 'Discusiones comenzadas por {$a->fullname} en {$a->coursename}';
$string['discussionstartedby'] = 'Discusión iniciada por {$a}';
$string['discussionsubscribed'] = 'Usted está ahora suscrito a esta discusión.';
$string['discussionsubscribestart'] = 'Mandarme notificaciones d enuevas publicaciones en esta discusión';
$string['discussionsubscribestop'] = 'No quiero ser notificado acerca de nuevas publicaciones en esta discusión';
$string['discussionsubscription'] = 'Suscripción a discusión';
$string['discussionsubscription_help'] = 'Suscripción a discusión significa que Usted recibirá notificaciones de nuevas publicaciones en esta discusión.';
$string['discussionunpin'] = 'Quitar fijación de discusión';
$string['discussionunsubscribed'] = 'Usted está ahora des-suscrito de esta discusión.';
$string['discussthistopic'] = 'Discutir este tópico/tema';
$string['discusstopicname'] = 'Discutir el tópico: {$a}';
$string['displayend'] = 'Mostrar final';
$string['displayend_help'] = '<p>Puede elegir si los mensajes del foro se muestran a partir de una fecha determinada, caducan en una fecha concreta o son visibles sólo a lo largo de un determinado período.</p>

<p>Deje sin seleccionar la(s) opcion(es) de deshabilitar para activar las fechas inicial y final en que son visibles los mensajes.</p>

<p>Tenga en cuenta que los usuarios con acceso de Administrador verán los mensajes antes de su fecha de aparición y después de su fecha de caducidad.</p>';
$string['displayenddate'] = 'Termina visualización: {$a}.';
$string['displaymode'] = 'Modo de visualización';
$string['displayperiod'] = 'Mostrar período';
$string['displaystart'] = 'Mostrar inicio';
$string['displaystart_help'] = '<p>Puede elegir si los mensajes del foro se muestran a partir de una fecha determinada, caducan en una fecha concreta o son visibles sólo a lo largo de un determinado período.</p>

<p>Deje sin seleccionar la(s) opcion(es) de deshabilitar para activar las fechas inicial y final en que son visibles los mensajes.</p>

<p>Tenga en cuenta que los usuarios con acceso de Administrador verán los mensajes antes de su fecha de aparición y después de su fecha de caducidad.</p>';
$string['displaystartdate'] = 'Inicia visualización: {$a}.';
$string['displaywordcount'] = 'Mostrar número de palabras';
$string['displaywordcount_help'] = 'Esta configuración especifica si es que se debería o no mostrar el número de palabras de cada publicación.';
$string['duedate'] = 'Fecha de entrega';
$string['duedate_help'] = 'Esto es cuando el foro está en fecha esperada. Aunque esta fecha es mostrada en el calendario como la fecha esperada para el foro, el publicar al foro todavía será permitido después de esta fecha. Configure una fecha límite del foro para evitar la publicación al foro después de cierta fecha -';
$string['duedatetodisplayincalendar'] = 'Fecha esperada a mostrar en calendario';
$string['eachuserforum'] = 'Cada persona plantea una discusión';
$string['edit'] = 'Editar';
$string['editedby'] = 'Editado por {$a->name} - envío original {$a->date}';
$string['editedpostupdated'] = 'El mensaje de {$a} fue actualizado';
$string['editing'] = 'Editando';
$string['emaildigestcompleteshort'] = 'Publicaciones completas';
$string['emaildigestdefault'] = 'Por defecto ({$a})';
$string['emaildigestoffshort'] = 'Sin resumen';
$string['emaildigestsubjectsshort'] = 'Solamente asuntos';
$string['emaildigesttype'] = 'Opciones del resumen de Email';
$string['emaildigesttype_help'] = 'El tipo de notificación que Usted recibirá para cada foro.

* Por defecto - sigue las configuraciones de resumen encontradas en su perfil de usuario. Si Usted actualiza su perfil, entonces dicho cambio se reflejará aquí también;
* Sin resumen - Usted recibirá un Email por cada publicación del foro;
* Resumen - publicaciones completas - Usted recibirá un resumen en Email diariamente con los contenidos completos de cada publicación del foro;
* Resumen - asuntos solamente - Usted recibirá un Email resumido diariamente conteniendo solamente los asuntos de cada publicación del foro.';
$string['emptymessage'] = 'Algo va mal con su mensaje. Tal vez lo haya enviado en blanco o el archivo adjunto, si lo hay, es demasiado grande. Sus cambios NO se han guardado.';
$string['errorcannotlock'] = 'Usted no tiene el permiso para bloquear discusiones.';
$string['erroremptymessage'] = 'El mensaje no puede estar vacío';
$string['erroremptysubject'] = 'El asunto del mensaje no puede estar vacío.';
$string['errorenrolmentrequired'] = 'Usted debe estar inscrito en este curso para acceder a este contendio';
$string['errorwhiledelete'] = 'Ha ocurrido un error al eliminar el registro';
$string['eventassessableuploaded'] = 'Algunos contenidos han sido publicados';
$string['eventcoursesearched'] = 'Curso buscado';
$string['eventdiscussioncreated'] = 'Discusión creada';
$string['eventdiscussiondeleted'] = 'Discusión eliminada';
$string['eventdiscussionmoved'] = 'Discusión movida';
$string['eventdiscussionpinned'] = 'Discusión fijada';
$string['eventdiscussionsubscriptioncreated'] = 'Suscripción a discusión creada';
$string['eventdiscussionsubscriptiondeleted'] = 'Suscripción a discusión eliminada';
$string['eventdiscussionunpinned'] = 'Discusión no fijada';
$string['eventdiscussionupdated'] = 'Discusión actualizada';
$string['eventdiscussionviewed'] = 'Discusión vista';
$string['eventpostcreated'] = 'Publicación creada';
$string['eventpostdeleted'] = 'Publicación eliminada';
$string['eventpostupdated'] = 'Publicación actualizada';
$string['eventreadtrackingdisabled'] = 'Lectura del seguimiento deshabilitada';
$string['eventreadtrackingenabled'] = 'Lectura del seguimiento habilitada';
$string['eventsubscribersviewed'] = 'Suscriptores vistos';
$string['eventsubscriptioncreated'] = 'Suscripción creada';
$string['eventsubscriptiondeleted'] = 'Suscripción eliminada';
$string['eventuserreportviewed'] = 'Reporte de usuario visto';
$string['everyonecanchoose'] = 'Todos pueden suscribirse';
$string['everyonecannowchoose'] = 'Ahora cualquiera puede elegir si se suscribe';
$string['everyoneisnowsubscribed'] = 'Ahora todos están suscritos a este foro';
$string['everyoneissubscribed'] = 'Todos están suscritos a este foro';
$string['existingsubscribers'] = 'Suscriptores existentes';
$string['export'] = 'Exportar';
$string['exportattachmentname'] = 'Exportar anexo {$a} al portafolio';
$string['exportdiscussion'] = 'Exportar la discusión completa al portafolios';
$string['exporthumandates'] = 'Fechas legibles por humano';
$string['exporthumandates_help'] = 'Si es que las fechas deberían de ser exportadas en un formato legible por humanos o como un sello de tiempo (secuencia de números).';
$string['exportoptions'] = 'Opciones para exportar';
$string['exportstriphtml'] = 'Quitar HTML';
$string['exportstriphtml_help'] = 'Si es que las marcas HTML como por ejemplo p y br deberían de ser quitadas del mensaje de publicación  del foro.';
$string['favourites'] = 'Destacado';
$string['favouriteupdated'] = 'Su opción de estrella ha sido actualizada.';
$string['firstpost'] = 'Primera publicación';
$string['forcedreadtracking'] = 'Permitir seguimiento de lectura forzado';
$string['forcedreadtracking_desc'] = 'Permite que los foros se puedan configurar a seguimiento de lectura forzada. Resultará en un rendimiento disminuído para algunos usuarios, particularmente en cursos con muchos foros y publicaciones en foros. Cuando está desconectado, cualquier foro que hubiera estado previamente configurado a \'Forzado\' se tratará como opcional.';
$string['forcesubscribed'] = 'Este foro fuerza la suscripción de todos';
$string['forcesubscribed_help'] = 'Este foro ha sido configurado de forma tal que Usted no puede des-suscribirse a las discusiones.';
$string['forum'] = 'Foro';
$string['forum:addinstance'] = 'Añadir un nuevo foro';
$string['forum:addnews'] = 'Añadir anuncios';
$string['forum:addquestion'] = 'Añadir pregunta';
$string['forum:allowforcesubscribe'] = 'Permitir suscripción forzosa';
$string['forum:canoverridecutoff'] = 'Publicar a foros después de su fecha límite';
$string['forum:canoverridediscussionlock'] = 'Contestación a discusiones bloqueadas';
$string['forum:canposttomygroups'] = 'Publicar en todos los grupos a los que Usted  tiene acceso';
$string['forum:cantogglefavourite'] = 'Poner estrella a discusiones';
$string['forum:createattachment'] = 'Crear archivos adjuntos';
$string['forum:deleteanypost'] = 'Eliminar cualquier mensaje (en cualquier momento)';
$string['forum:deleteownpost'] = 'Eliminar mensajes propios (antes de la fecha límite)';
$string['forum:editanypost'] = 'Editar cualquier mensaje';
$string['forum:exportdiscussion'] = 'Exportar la discusión completa';
$string['forum:exportforum'] = 'Exportar foro';
$string['forum:exportownpost'] = 'Exportar mensaje propio';
$string['forum:exportpost'] = 'Exportar mensaje';
$string['forum:grade'] = 'Calificar foro';
$string['forum:managesubscriptions'] = 'Gestionar suscriptores';
$string['forum:movediscussions'] = 'Mover discusiones';
$string['forum:pindiscussions'] = 'Fijar discusiones';
$string['forum:postprivatereply'] = 'Responder en privado a publicaciones';
$string['forum:postwithoutthrottling'] = 'Exentos del umbral de mensaje';
$string['forum:rate'] = 'Valorar mensajes';
$string['forum:readprivatereplies'] = 'Ver respuestas privadas';
$string['forum:replynews'] = 'Responder (réplica) a anuncios';
$string['forum:replypost'] = 'Responder (réplica) a mensajes';
$string['forum:splitdiscussions'] = 'Separar discusiones';
$string['forum:startdiscussion'] = 'Comenzar nuevas discusiones';
$string['forum:viewallratings'] = 'Ver todas las valuaciones (ratings) emitidas por las usuarios';
$string['forum:viewanyrating'] = 'Ver el total de valuaciones (ratings) que alguien recibió';
$string['forum:viewdiscussion'] = 'Ver discusiones';
$string['forum:viewhiddentimedposts'] = 'Ver mensajes agendados ocultos';
$string['forum:viewqandawithoutposting'] = 'Ver siempre mensajes de P y R';
$string['forum:viewrating'] = 'Ver valuación (rating) total recibida';
$string['forum:viewsubscribers'] = 'Ver suscriptores';
$string['forumauthorhidden'] = 'Autor (oculto)';
$string['forumblockingalmosttoomanyposts'] = 'Usted se está aproximando al límite permitido de mensajes. Ha enviado {$a->numposts} mensajes en el último {$a->blockperiod} y el límite está en {$a->blockafter} mensajes.';
$string['forumbodydeleted'] = 'El contenido de esta publicación en foro ha sido removido y ya no puede accederse a él.';
$string['forumbodyhidden'] = 'Usted no puede ver este mensaje, probablemente porque Usted no ha enviado mensajes a la discusión o porque aún no ha transcurrido el tiempo máximo para editar la discusión, o la discusión no ha comenzado o ya expiró.';
$string['forumgrader'] = 'Calificador del foro';
$string['forumgradingnavigation'] = 'Navegación de valoración del foro';
$string['forumgradingpanel'] = 'Panel de valoración del foro';
$string['forumintro'] = 'Descripción';
$string['forumname'] = 'Nombre del foro';
$string['forumposts'] = 'Mensajes en foros';
$string['forums'] = 'Foros';
$string['forumsubjectdeleted'] = 'Esta publicación en foro ha sido removida';
$string['forumsubjecthidden'] = 'Tema (oculto)';
$string['forumtracked'] = 'Se están rastreando los mensajes no leídos';
$string['forumtrackednot'] = 'Los mensajes no leídos no se están rastreando';
$string['forumtype'] = 'Tipo de foro';
$string['forumtype_help'] = '<P>Hay cinco tipos diferentes de foros entre los que elegir:

* Una discusión única simple- Es simplemente un intercambio de ideas sobre un solo tema, todo en una página. Útil para debates cortos y concretos. Todos pueden responder al tema de discusión. No puede usarse con grupos separados.

* Cada persona plantea un tópico/tema a discusión - Cada persona puede plantear exactamente un nuevo tópico/tema de discusión (y todos pueden responder). Esta modalidad es útil cuando usted quiere que cada estudiante empiece una discusión sobre, digamos, sus reflexiones sobre el tema de la semana, y que todos los demás le puedan responder.

* Foro de Preguntas y Respuestas - Los estudiantes primero deben escribir sus puntos de vista antes de ver los mensajes de los demás.

* Foro General mostrado en formato similar a Blog - Un foro abierto donde cualquiera puede iniciar un nuevo debate en cualquier momento y en el que los temas de discusión se muestran en una página con enlaces "Discute este tema".

* Foro estándar para uso general - Es un foro abierto donde cualquiera puede empezar un nuevo tema de discusión en cualquier momento. Este es el foro más adecuado, para uso general.';
$string['generalforum'] = 'Foro estándar para uso general';
$string['generalforums'] = 'Foros generales';
$string['grade_forum_header'] = 'Calificación de todo el foro';
$string['grade_forum_name'] = 'Todo el foro';
$string['grade_forum_title'] = 'Calificación';
$string['grade_rating_name'] = 'Valoración';
$string['graded'] = 'Calificado';
$string['gradedby'] = 'Calificado por';
$string['gradeforrating'] = 'Calificación por valoración: {$a->str_long_grade}';
$string['gradeforratinghidden'] = 'Calificación por valoración oculta';
$string['gradeforwholeforum'] = 'Calificación para foro: {$a->str_long_grade}';
$string['gradeforwholeforumhidden'] = 'Calificación para foro oculta';
$string['gradeitem:forum'] = 'Foro';
$string['gradeitemnameforrating'] = 'Valoración para {$a->name}';
$string['gradeitemnameforwholeforum'] = 'todo el foro {$a->name}';
$string['grades:gradesavedfor'] = 'Calificación guardada para {$a->fullname}';
$string['grades:gradesavefailed'] = 'No se puede guardar calificación para {$a->fullname}: {$a->error}';
$string['gradeusers'] = 'Calificar usuarios';
$string['grading'] = 'Calificando';
$string['gradingstatus'] = 'Estado de la calificación:';
$string['hiddenforumpost'] = 'Publicación oculta en foro';
$string['hidegraderpanel'] = 'Ocultar panel calificador';
$string['hidepreviousrepliescount'] = 'Ocultar contestaciones anteriores ({$a})';
$string['hideusersearch'] = 'Ocultar búsqueda usuario';
$string['indexoutoftotal'] = '{$a->index} de un total de {$a->total}';
$string['indicator:cognitivedepth'] = 'Foro cognitiva';
$string['indicator:cognitivedepth_help'] = 'Este indicador está basado en la profundidad cognitiva alcanzada por el estudiante en una actividad Foro.';
$string['indicator:cognitivedepthdef'] = 'Foro cognitiva';
$string['indicator:cognitivedepthdef_help'] = 'El participante ha alcanzado este porcentaje del compromiso cognitivo ofrecido por las actividades de Foro durante este intervalo de análisis (Niveles = Sin Ver, Ver, Enviar, Ver retroalimentación, Comentar en retroalimentación, Reenviar después de ver retroalimentación)';
$string['indicator:socialbreadth'] = 'Foro social';
$string['indicator:socialbreadth_help'] = 'Este indicador está basado en la amplitud social alcanzada por el estudiante en una actividad Foro.';
$string['indicator:socialbreadthdef'] = 'Foro social';
$string['indicator:socialbreadthdef_help'] = 'El participante ha alcanzado este porcentaje del compromiso social ofrecido por las actividades de Foro  durante este intervalo de análisis (Niveles = Sin participación, Participante solo, Participante con otros)';
$string['inforum'] = 'en {$a}';
$string['inpagereplysubject'] = 'Re: {$a}';
$string['inreplyto'] = 'En respuesta a {$a}';
$string['introblog'] = 'Los mensajes de este foro fueron copiados aquí de forma automática a partir de los blogs de los usuarios de este curso debido a que esas entradas de blog ya no están disponibles';
$string['intronews'] = 'Avisos y novedades generales';
$string['introsocial'] = 'Foro abierto a todos los temas';
$string['introteacher'] = 'Foro de notas y discusiones exclusivo para profesores';
$string['invalidaccess'] = 'No se ha accedido correctamente a esta página';
$string['invaliddigestsetting'] = 'Se proporcionó una configuración inválida para resumen de Email';
$string['invaliddiscussionid'] = 'El ID de la discusión es incorrecto o ya no existe';
$string['invalidforcesubscribe'] = 'Modo de suscripción forzada no válido';
$string['invalidforumid'] = 'El ID del foro es incorrecto';
$string['invalidparentpostid'] = 'La ID del mensaje padre es incorrecta';
$string['invalidpostid'] = 'ID de mensaje no válido - {$a}';
$string['lastpost'] = 'Último mensaje';
$string['learningforums'] = 'Foros de aprendizaje';
$string['lockdiscussion'] = 'Bloquear esta discusión';
$string['lockdiscussionafter'] = 'Bloquear discusiones después de período de inactividad';
$string['lockdiscussionafter_help'] = 'Las discusiones pueden ser bloqueadas automáticamente después de que haya transcurrido un tiempo especificado desde la última respuesta.

Los usuarios con la capacidad para responder a discusiones bloqueadas pueden desbloquear una discusión al contestarla.';
$string['locked'] = 'Bloqueado';
$string['lockupdated'] = 'La opción para bloquear ha sido actualizada.';
$string['longpost'] = 'Mensaje largo';
$string['mailnow'] = 'Enviar notificaciones de publicación en foro sin retraso de tiempo para editar.';
$string['managesubscriptionsoff'] = 'Terminar de gestionar suscripciones';
$string['managesubscriptionson'] = 'Gestionar suscriptores';
$string['manydiscussions'] = 'Discusiones por página';
$string['markalldread'] = 'Marcar como leídos todos los mensajes de esta discusión.';
$string['markallread'] = 'Marcar como leídos todos los mensajes de este foro.';
$string['markasread'] = 'Marcar como leído';
$string['markasreadonnotification'] = 'Al enviar notificaciones de publicación en foro';
$string['markasreadonnotification_help'] = 'Cuando Usted es notificado de una publicación en foro, Usted puede elegir si esto debería de marcar la publicación como leída para el propósito de rastreo del foro.';
$string['markasreadonnotificationno'] = 'No marcar la publicación como leída';
$string['markasreadonnotificationyes'] = 'Marcar la publicación como leída';
$string['markread'] = 'Marcar como leído';
$string['markreadbutton'] = 'Marcar<br />leídos';
$string['markunread'] = 'Marcar como no leído';
$string['markunreadbutton'] = 'Marcar<br />no leídos';
$string['maxattachments'] = 'Número máximo de archivos adjuntos';
$string['maxattachments_help'] = 'Este ajuste determina el número máximo de archivos que se pueden adjuntar a un mensaje en el foro.';
$string['maxattachmentsize'] = 'Tamaño máximo del archivo adjunto';
$string['maxattachmentsize_help'] = '<P>El tamaño de los archivos adjuntos pueden ser limitado por la persona
   que configura el foro.

<P>En ocasiones es posible subir un archivo de un tamaño mayor al especificado,
   pero en este caso no se guardará en el servidor y aparecerá un mensaje de error.';
$string['maxtimehaspassed'] = '¡Lo sentimos, pero el tiempo máximo para editar esta publicación  ({$a}) ya venció!';
$string['message'] = 'Mensaje';
$string['messageinboundattachmentdisallowed'] = 'No puede publicarse su respuesta, porque incluye un anexo y el foro no permite anexos.';
$string['messageinboundfilecountexceeded'] = 'No puede publicarse su respuesta, porque incluye un número de anexos mayor al permitido por el foro ({$a->forum->maxattachments}).';
$string['messageinboundfilesizeexceeded'] = 'No puede publicarse su respuesta, porque  el tamaño total de anexos  ({$a->filesize}) es mayor del tamaño máximo permitido para el foro ({$a->maxbytes}).';
$string['messageinboundforumhidden'] = 'No puede publicarse su respuesta, porque el foro actualmente no está disponible.';
$string['messageinboundnopostforum'] = 'No puede publicarse su respuesta, porque Usted no tiene permiso para publicar en el foro {$a->forum->name} .';
$string['messageinboundthresholdhit'] = 'No puede publicarse su respuesta. Usted ha excedido el umbral de publicación configurado para este foro';
$string['messageprovider:digests'] = 'Compendios suscritos del foro';
$string['messageprovider:posts'] = 'Mensajes suscritos del foro';
$string['missingsearchterms'] = 'Los siguientes términos de búsqueda sólo tienen lugar en la marca HTML de este mensaje:';
$string['modeflatnewestfirst'] = 'Ordenar desde el más reciente';
$string['modeflatoldestfirst'] = 'Ordenar desde el más antiguo';
$string['modenested'] = 'Mostrar respuestas anidadas';
$string['modenestedv2'] = 'Mostrar respuestas en formato anidado experimental';
$string['modethreaded'] = 'Mostrar respuestas por rama';
$string['modulename'] = 'Foro';
$string['modulename_help'] = 'El módulo de actividad Foro les permite a los participantes tener discusiones asincrónicas (en diferentes tiempos), que suceden a lo largo de un largo período de tiempo.

Existen varios tipos de foros a elegir, como el foro estándar donde cualquiera puede empezar una nueva discusión en cualquier momento, un foro donde cada estudiante solamente puede publicar exactamente una discusión, un foro de preguntas y respuestas donde los estudiantes deben publicar un mensaje antes de poder ver los mensajes de los otros estudiantes. Un profesor puede permitir que se anexen archivos a los mensajes del foro y las imágenes anexas se mostrarán en el mensaje del foro.

Los participantes pueden suscribirse al foro para recibir avisos de nuevos mensajes en el foro. Un profesor puede configurar el modo de suscripción a opcional, forzado o auto, o impedir completamente las suscripciones. Si se requiere, se puede prohibir a los alumnos que publiquen más de un número determinado de mensajes en un período de tiempo para evitar que algún individuo acapare las discusiones.

Los mensajes de foros se pueden calificar por los profesores y por los alumnos (evaluación por pares). Las calificaciones de agregan para formar una calificación final que se guarda en el libro de calificaciones.

Los foros tienen varios usos como

* Un espacio introductorio para que los estudiantes del curso se conozcan entre ellos
* Un espacio para avisos del curso (empleando un foro de noticias con suscripción forzosa)
* Un centro de ayuda donde los tutores y alumnos pueden dar orientación
* Un método informal para compartir (y potencialmente hacer evaluación por pares) documentos entre estudiantes
* Para continuar en línea un tema que surgió previamente en una sesión de clase presencial
* Un lugar para que los profesores discutan entre ellos (empleando un foro oculto a los alumnos)
* Para actividades de extensión, por ejemplo, desafíos mentales para que los alumnos ponderen y sugieran soluciones
* Un espacio social para discusiones fuera del tema del curso';
$string['modulenameplural'] = 'Foros';
$string['more'] = 'más';
$string['movedmarker'] = '(Trasladada)';
$string['movethisdiscussionlabel'] = 'Mover la discusión actual al foro especificado';
$string['movethisdiscussionto'] = 'Mover esta discusión a ...';
$string['mustprovidediscussionorpost'] = 'Debe proporcionar una de dos opciones: ID de discusión o ID del mensaje para exportar.';
$string['myprofileotherdis'] = 'Discusiones del foro';
$string['myprofileowndis'] = 'Mis discusiones del foro';
$string['myprofileownpost'] = 'Mis publicaciones del foro';
$string['namenews'] = 'Avisos';
$string['namenews_help'] = 'El foro de Avisos del curso es un foro especial para avisos que se crea automáticamente cuando se crea un curso. Un curso puede tener sólo un foro de Avisos. Sólo los profesores y los administradores pueden escribir en el foro de Avisos. El bloque de "Avisos recientes" mostrará los avisos recientes.';
$string['namesocial'] = 'Foro social';
$string['nameteacher'] = 'Foro de profesores';
$string['newforumposts'] = 'Nuevos mensajes en foros';
$string['nextdiscussiona'] = 'Discusión siguiente: {$a}';
$string['nextuser'] = 'Guardar cambios y proceder al usuario siguiente';
$string['noattachments'] = 'No hay archivos adjuntos a este mensaje';
$string['nodiscussions'] = 'Aún no hay tópicos/temas de discusión en este foro';
$string['nodiscussionsstartedby'] = '{$a} no ha comenzado ninguna discusión';
$string['nodiscussionsstartedbyyou'] = 'Usted no ha empezado aún ninguna discusión';
$string['noguestpost'] = 'Lo sentimos, los invitados no pueden enviar mensajes.';
$string['noguestsubscribe'] = 'Lo sentimos,los invitados no tienen permitido suscribirse.';
$string['noguesttracking'] = 'Lo sentimos, los invitados no pueden ajustar opciones de seguimiento.';
$string['nomorepostscontaining'] = 'No se encontraron más mensajes que contengan \'{$a}\'';
$string['nonews'] = 'Todavía no se han publicado anuncios.';
$string['noonecansubscribenow'] = 'Las suscripciones no están permitidas ahora';
$string['nopermissiontosubscribe'] = 'No tiene permiso para ver los suscriptores del foro';
$string['nopermissiontoview'] = 'No tiene permiso para ver este mensaje';
$string['nopostforum'] = 'Lo sentimos, no puede enviar mensajes a este foro';
$string['noposts'] = 'No hay mensajes';
$string['nopostsmadebyuser'] = '{$a} no ha hecho publicaciones';
$string['nopostsmadebyyou'] = 'Usted no ha realizado ninguna aportación';
$string['noquestions'] = 'Aún no hay preguntas en este foro';
$string['nosubscribers'] = 'Nadie se ha suscrito aún a este foro';
$string['notexists'] = 'La discusión ya no existe';
$string['notgraded'] = 'No calificado';
$string['nothingnew'] = 'Nada nuevo para {$a}';
$string['notingroup'] = 'Lo sentimos, pero debe formar parte del grupo para poder ver este foro.';
$string['notinstalled'] = 'El módulo foro no está instalado';
$string['notlocked'] = 'Bloquear';
$string['notpartofdiscussion'] = '¡Este mensaje no es parte de una discusión!';
$string['notrackforum'] = 'No rastrear mensajes no leídos';
$string['notsubscribed'] = 'Suscribir';
$string['nousersmatch'] = 'Sin usuario(s) encontrado(s) para criterios dados';
$string['noviewdiscussionspermission'] = 'Usted no tiene permiso para ver discusiones en este foro';
$string['nowallsubscribed'] = 'Usted está suscrito a todos los foros en {$a}.';
$string['nowallunsubscribed'] = 'Usted ahora está des-suscrito de todos los foros en {$a}.';
$string['nowgradinguser'] = 'Ahora calificando a {$a}';
$string['nownotsubscribed'] = '{$a->name} NO será notificado acerca de nuevas publicaciones en \'{$a->forum}\' por correo.';
$string['nownottracking'] = '{$a->name} ya no está rastreando \'{$a->forum}\'.';
$string['nowsubscribed'] = '{$a->name} será notificado acerca de nuevas publicaciones en \'{$a->forum}\'';
$string['nowtracking'] = '{$a->name} está rastreando \'{$a->forum}\' en este momento.';
$string['numberofreplies'] = 'Número de respuestas: {$a}';
$string['numposts'] = '{$a} publicaciones';
$string['olderdiscussions'] = 'Discusiones anteriores';
$string['oldertopics'] = 'Tópicos/Temas antiguos';
$string['oldpostdays'] = 'Leer después de días';
$string['overviewnumpostssince'] = '{$a} mensajes desde el último ingreso';
$string['overviewnumunread'] = '{$a} no leídos';
$string['page-mod-forum-discuss'] = 'Página del hilo de la discusión del módulo Foro';
$string['page-mod-forum-view'] = 'Página principal del módulo Foro';
$string['page-mod-forum-x'] = 'Cualquier página del módulo Foro';
$string['parent'] = 'Mostrar mensaje anterior';
$string['parentofthispost'] = 'Anterior a este mensaje';
$string['permalink'] = 'Enlace permanente';
$string['permanentlinktoparentpost'] = 'Enlace permanente al padre de esta publicación';
$string['permanentlinktopost'] = 'Enlace permanente a esta publicación';
$string['pindiscussion'] = 'Fijar esta discusión';
$string['pinupdated'] = 'La opción de fijación ha sido actualizada.';
$string['pluginadministration'] = 'Administración del foro';
$string['pluginname'] = 'Foro';
$string['postadded'] = '<p>Su mensaje se ha enviado con éxito.</p> <p>Tiene {$a} para editar si desea hacer cualquier cambio.</p>';
$string['postaddedsuccess'] = 'Su mensaje ha sido añadido con éxito.';
$string['postaddedtimeleft'] = 'Dispone de {$a} para editarlo si quiere hacer cualquier cambio.';
$string['postbymailsuccess'] = 'Su respuesta a "{$a->subject}" fue exitosamente publicada: {$a->discussionurl}';
$string['postbymailsuccess_html'] = 'Su respuesta a  < <a href="{$a->discussionurl}">{$a->subject}</a>  fue publicada exitosamente.';
$string['postbyuser'] = '{$a->post} por {$a->user}';
$string['postincontext'] = 'Ver el mensaje en su contexto';
$string['postisprivatereply'] = 'Esta es una contestación privada. No es visible para otros participantes.';
$string['postmailinfolink'] = 'Esta es una copia de un mensaje publicado en  {$a->coursename}.

Para responder, haga clic en este enlace: {$a->replylink}';
$string['postmailnow'] = '<p>Este mensaje será enviado inmediatamente a todos los suscritos al foro.</p>';
$string['postmailsubject'] = '{$a->courseshortname}: {$a->subject}';
$string['postrating1'] = 'Muy individualista';
$string['postrating2'] = 'Término medio';
$string['postrating3'] = 'Muy comunicativo';
$string['posts'] = 'Mensajes';
$string['postsfrom'] = 'Publicaciones de';
$string['postsmadebyuser'] = 'Publicaciones hechas por por {$a}';
$string['postsmadebyuserincourse'] = 'Comentarios hechos por {$a->fullname} en {$a->coursename}';
$string['poststo'] = 'Publicaciones para';
$string['posttoforum'] = 'Enviar al foro';
$string['posttomygroups'] = 'Publicar una copia a todos los grupos';
$string['posttomygroups_help'] = 'Publicar una copia de este mensaje a todos los grupos a los que Usted tenga acceso. Los participantes en los grupos a los que Usted no tenga acceso no verán esta publicación.';
$string['postupdated'] = 'Su mensaje se ha actualizado';
$string['potentialsubscribers'] = 'Suscriptores potenciales';
$string['prevdiscussiona'] = 'Discusión anterior: {$a}';
$string['previoususer'] = 'Guardar cambios y proceder al usuario anterior';
$string['privacy:digesttypenone'] = 'Nosotros no conservamos ningún dato relacionado con un tipo de resumen de foro preferido para este foro.';
$string['privacy:digesttypepreference'] = 'Usted ha elegido recibir el siguiente tipo de resumen del foro: "{$a->type}".';
$string['privacy:discussionsubscriptionpreference'] = 'Usted ha elegido la siguiente preferencia de suscripción a discusión para este foro: "{$a->preference}"';
$string['privacy:metadata:core_rating'] = 'El foro hace uso del subsistema de valoración para soportar la valoración de publicaciones.';
$string['privacy:metadata:core_tag'] = 'El foro hace uso del subsistema de marca para soportar el marcado de publicaciones.';
$string['privacy:metadata:forum_digests'] = 'Información acerca de las preferencias del resumen para cada foro.';
$string['privacy:metadata:forum_digests:forum'] = 'El foro suscrito a.';
$string['privacy:metadata:forum_digests:maildigest'] = 'La preferencia del resumen.';
$string['privacy:metadata:forum_digests:userid'] = 'La Id del usuario con la preferencia del resumen.';
$string['privacy:metadata:forum_discussion_subs'] = 'Información acerca de las suscripciones a discusiones individuales de foro';
$string['privacy:metadata:forum_discussion_subs:discussionid'] = 'La ID de la discusión a la cual estaba suscrito.';
$string['privacy:metadata:forum_discussion_subs:preference'] = 'La hora de inicio de la suscripción.';
$string['privacy:metadata:forum_discussion_subs:userid'] = 'La ID del usuario con la suscripción a discusión.';
$string['privacy:metadata:forum_discussions'] = 'Información acerca de las discusiones de foro individuales que un usuario ha creado';
$string['privacy:metadata:forum_discussions:assessed'] = 'TODOD - qué almacena este campo';
$string['privacy:metadata:forum_discussions:name'] = 'El nombre de la discusión, como fue elegido por el autor.';
$string['privacy:metadata:forum_discussions:timemodified'] = 'La hora en la cual la discusión fue modificada por última vez.';
$string['privacy:metadata:forum_discussions:userid'] = 'La ID del usuario que creó la discusión';
$string['privacy:metadata:forum_discussions:usermodified'] = 'La Id del usuario que modificó por última vez la discusión de alguna manera.';
$string['privacy:metadata:forum_grades'] = 'Datos de calificación para el foro';
$string['privacy:metadata:forum_grades:forum'] = 'El foro que fue calificado';
$string['privacy:metadata:forum_grades:grade'] = 'La calificación otorgada';
$string['privacy:metadata:forum_grades:userid'] = 'El usuario que fue calificado';
$string['privacy:metadata:forum_posts'] = 'Información acerca de las preferencias del resumen para cada foro.';
$string['privacy:metadata:forum_posts:created'] = 'La hora en la que fue creada la publicación.';
$string['privacy:metadata:forum_posts:discussion'] = 'La discusión en donde está la publicación.';
$string['privacy:metadata:forum_posts:message'] = 'El mensaje de la publicación del foro.';
$string['privacy:metadata:forum_posts:modified'] = 'La hora en la cual la publicación fue modificada por última vez.';
$string['privacy:metadata:forum_posts:parent'] = 'La discusión paterna a la cual se respondió.';
$string['privacy:metadata:forum_posts:privatereplyto'] = 'La ID del usuario a quien se le envió esta respuesta.';
$string['privacy:metadata:forum_posts:subject'] = 'El asunto de la publicación del foro.';
$string['privacy:metadata:forum_posts:totalscore'] = 'El mensaje de la publicación del foro.';
$string['privacy:metadata:forum_posts:userid'] = 'La ID del usuario que hizo la publicación del foro.';
$string['privacy:metadata:forum_queue'] = 'Bitácora temporal de publicaciones que serán enviadas en forma resumida';
$string['privacy:metadata:forum_queue:discussionid'] = 'ID del foro de discusión';
$string['privacy:metadata:forum_queue:postid'] = 'ID de la publicación del foro';
$string['privacy:metadata:forum_queue:timemodified'] = 'La hora modificada de la publicación original';
$string['privacy:metadata:forum_queue:userid'] = 'Usuario que necesita ser notificado acerca de la publicación';
$string['privacy:metadata:forum_read'] = 'Información acerca de cuales publicaciones han sido leídas por el usuario.';
$string['privacy:metadata:forum_read:discussionid'] = 'La discusión en donde está la publicación.';
$string['privacy:metadata:forum_read:firstread'] = 'La primera vez que la publicación fue leída.';
$string['privacy:metadata:forum_read:lastread'] = 'La hora más reciente cuando la publicación fue leída.';
$string['privacy:metadata:forum_read:postid'] = 'La publicación que fue leída.';
$string['privacy:metadata:forum_read:userid'] = 'La ID del usuario al cual se relaciona este registro.';
$string['privacy:metadata:forum_subscriptions'] = 'Información acerca de a cuales foros se ha suscrito el usuario.';
$string['privacy:metadata:forum_subscriptions:forum'] = 'El foro al cual estaba suscrito.';
$string['privacy:metadata:forum_subscriptions:userid'] = 'La ID del usuario a la cual se relaciona esta suscripción al foro.';
$string['privacy:metadata:forum_track_prefs'] = 'Información acerca de para cuales foros el usuario ha elegido monitorear las lecturas.';
$string['privacy:metadata:forum_track_prefs:forumid'] = 'El foro que tiene seguimiento de lectura habilitado.';
$string['privacy:metadata:forum_track_prefs:userid'] = 'La ID del usuario con el que se relaciona la preferencia de monitoreo del foro.';
$string['privacy:metadata:preference:autosubscribe'] = 'Si es que se suscribe o no a discusiones al contestar a publicaciones adentro de elllas.';
$string['privacy:metadata:preference:forum_discussionlistsortorder'] = 'El orden preferente para ordenar la lista de discusiones';
$string['privacy:metadata:preference:maildigest'] = 'La preferencia de resumen de Email para todo el sitio';
$string['privacy:metadata:preference:markasreadonnotification'] = 'Si es que se marca o no publicaciones de foro como leídas al recibirlas como mensajes.';
$string['privacy:metadata:preference:trackforums'] = 'Si es que se habilita o no seguimiento de lectura.';
$string['privacy:postwasread'] = 'Esta publicación fue leída primeramente en {$a->firstread} y leída más recientemente en {$a->lastread}';
$string['privacy:readtrackingdisabled'] = 'Usted ha elegido no monitorear cuales publicaciones ha leído Usted dentro de este foro.';
$string['privacy:request:delete:discussion:name'] = 'Eliminar a solicitud del autor';
$string['privacy:request:delete:post:message'] = 'El contenido de esta publicación ha sido eliminado a solicitud de su autor.';
$string['privacy:request:delete:post:subject'] = 'Eliminar a solicitud del autor';
$string['privacy:subscribedtoforum'] = 'Usted está suscrito a este foro.';
$string['privatereply'] = 'Responder en privado';
$string['privatereply_help'] = 'Una respuesta privada solamente puede ser vista por el autor de la publicación a la cual se responde, y cualquier usuario con la capacidad para ver respuestas privadas.';
$string['processingdigest'] = 'Procesando el resumen por correo para el usuario {$a}';
$string['processingpost'] = 'Procesando publicación  {$a}';
$string['prune'] = 'Separar';
$string['prunedpost'] = 'Se ha creado una nueva discusión a partir de ese mensaje';
$string['pruneheading'] = 'Separar la discusión y mover este mensaje hacia una discusión nueva';
$string['qandaforum'] = 'Foro Preguntas y Respuestas';
$string['qandanotify'] = 'Este es un foro de Preguntas y Respuestas. Para ver otras respuestas, debe primero enviar la suya';
$string['re'] = 'Re:';
$string['readtherest'] = 'Ver el resto de este tópico/tema';
$string['removeallforumtags'] = 'Quitar todas las marcas del foro';
$string['removefromfavourites'] = 'Quitar estrella de esta discusión';
$string['replies'] = 'Réplicas';
$string['repliesmany'] = '{$a} réplicas hasta el momento';
$string['repliesone'] = '{$a} réplica hasta el momento';
$string['reply'] = 'Responder (réplica)';
$string['reply_handler'] = 'Contestar por Email a publicaciones en foro';
$string['reply_handler_name'] = 'Contestar a publicaciones en foro';
$string['replyauthorself'] = '{$a} (Usted)';
$string['replyforum'] = 'Responder (réplica) al foro';
$string['replyingtoauthor'] = 'Contestando a {$a}...';
$string['replyplaceholder'] = 'Escriba su respuesta...';
$string['replytopostbyemail'] = 'Usted puede responder a esto por Email.';
$string['replytouser'] = 'Usar dirección email en réplica';
$string['resetdigests'] = 'Eliminar todas las preferencias de usuarios para resúmenes de foros';
$string['resetforums'] = 'Eliminar mensajes de';
$string['resetforumsall'] = 'Eliminar todos los mensajes';
$string['resetsubscriptions'] = 'Eliminar todas las suscripciones al foro';
$string['resettrackprefs'] = 'Eliminar todas las preferencias de seguimiento de los foros';
$string['rssarticles'] = 'Número de artículos recientes RSS';
$string['rssarticles_help'] = '<P>Esta opción le permite seleccionar el número de artículos a incluir
   en el Canal RSS.

<P>Un número comprendido entre 5 y 20 debería ser apropiado para la mayoría
   de los foros. Auméntelo si se trata de un foro muy utilizado.';
$string['rsssubscriberssdiscussions'] = 'Canal RSS de discusiones';
$string['rsssubscriberssposts'] = 'Canal RSS de mensajes';
$string['rsstype'] = 'Canal RSS de esta actividad';
$string['rsstype_help'] = '<P>Esta opción le permite habilitar los canales RSS en este foro. <P>Puede escoger entre dos tipos de foros: <UL> <LI><B>Discusiones:</B> Con esta opción, los datos generados incluirán nuevas discusiones en el foro con su mensaje inicial. <LI><B>Mensajes:</B> Con esta opción, los datos generados incluirán cada nuevo mensaje en el foro. </UL>';
$string['rsstypedefault'] = 'Tipo de canal RSS';
$string['search'] = 'Buscar';
$string['search:activity'] = 'Foro - información de actividad';
$string['search:post'] = 'Foro - publicaciones';
$string['searchdatefrom'] = 'Los mensajes deben ser más recientes que este';
$string['searchdateto'] = 'Los mensajes deben ser más antiguos que este';
$string['searchforumintro'] = 'Por favor, introduzca los términos de búsqueda en uno o más de los campos siguientes:';
$string['searchforums'] = 'Buscar en foros';
$string['searchfullwords'] = 'Estas palabras deberían aparecer como palabras completas';
$string['searchnotwords'] = 'Estas palabras NO deberían incluirse';
$string['searcholderposts'] = 'Buscar mensajes antiguos...';
$string['searchphrase'] = 'En el mensaje debería aparecer esta frase exacta';
$string['searchresults'] = 'Resultado';
$string['searchsubject'] = 'Estas palabras deberían figurar en el asunto';
$string['searchtags'] = 'Está marcado con';
$string['searchuser'] = 'Este nombre debería corresponder al del autor';
$string['searchuserid'] = 'ID del autor en Moodle';
$string['searchusers'] = 'Buscar usuarios';
$string['searchwhichforums'] = 'Elegir en qué foros buscar';
$string['searchwords'] = 'Estas palabras pueden aparecer en cualquier lugar del mensaje';
$string['seeallposts'] = 'Ver todos los mensajes de este usuario';
$string['sendstudentnotificationsdefault'] = 'Configuración predeterminada para "Notificar estudiantes"';
$string['sendstudentnotificationsdefault_help'] = 'Configurar el valor predeterminado para la casilla  "Notificar estudiantes" en el formato de calificación.';
$string['sendstudentnotificationsno'] = 'No';
$string['sendstudentnotificationsyes'] = 'Si; enviar notificación al estudiante';
$string['settings'] = 'Configuraciones';
$string['shortpost'] = 'Mensaje corto';
$string['showgraderpanel'] = 'Mostrar panel calificador';
$string['showingcountoftotaldiscussions'] = 'Lista de discusiones. Mostrando {$a->count} de {$a->total} discusiones';
$string['showmoreusers'] = 'Mostrar más usuarios';
$string['showpreviousrepliescount'] = 'Mostrar contestaciones anteriores ({$a})';
$string['showsubscribers'] = 'Mostrar/editar suscriptores actuales';
$string['showusersearch'] = 'Mostrar buscar usuario';
$string['singleforum'] = 'Una discusión única simple';
$string['smallmessage'] = '{$a->user} envió un mensaje a {$a->forumname}';
$string['smallmessagedigest'] = 'Resumen del foro conteniendo {$a} mensajes';
$string['starredonly'] = 'Buscar solamente discusiones destacadas';
$string['startedby'] = 'Comenzado por';
$string['subject'] = 'Asunto';
$string['subscribe'] = 'Suscribirse a este foro';
$string['subscribeall'] = 'Suscribir a todos a este foro';
$string['subscribed'] = 'Suscrito';
$string['subscribediscussion'] = 'Suscribirse a esta discusión';
$string['subscribeenrolledonly'] = 'Sólo los usuarios registrados pueden suscribirse a las notificaciones de publicaciones en foros.';
$string['subscribenone'] = 'Dar de baja a todos de este foro';
$string['subscribers'] = 'Suscriptores';
$string['subscriberstowithcount'] = 'Suscriptores a "{$a->name}" ({$a->count})';
$string['subscribestart'] = 'Envíenme notificaciones de nuevas publicaciones en este foro';
$string['subscribestop'] = 'No deseo ser notificado acerca de nuevas publicaciones de este foro';
$string['subscription'] = 'Suscripción';
$string['subscription_help'] = 'Si Usted está suscrito a un foro esto significa que Usted recibirá notificaciones acerca de nuevas publicaciones en el foro. Usualmente Usted puede elegir si desea suscribirse o no, aunque en ocasiones está forzada la suscripción para que todos reciban notificaciones.';
$string['subscriptionandtracking'] = 'Suscripción y seguimiento';
$string['subscriptionauto'] = 'Suscripción automática';
$string['subscriptiondisabled'] = 'Suscripción deshabilitada';
$string['subscriptionforced'] = 'Suscripción forzosa';
$string['subscriptionmode'] = 'Modalidad de suscripción';
$string['subscriptionmode_help'] = 'Cuando un participante está suscrito a un foro, esto significa que recibirá notificaciones de publicaciones en ese foro. Hay 4 modos de suscripción:

* Suscripción opcional - Los participantes pueden elegir si desean o no ser suscritos.
* Suscripción forzosa - Todos están suscritos y no puede darse de baja.
* Auto suscripción - Todos están suscritos inicialmente, pero cada usuario puede elegir desactivar la suscripción en cualquier momento.
* Suscripción desactivada - No se permiten suscripciones.';
$string['subscriptionoptional'] = 'Suscripción opcional';
$string['subscriptions'] = 'Suscripciones';
$string['tagarea_forum_posts'] = 'Publicaciones en foro';
$string['tagsdeleted'] = 'Marcas del foro que han sido eliminadas';
$string['thisforumhasduedate'] = 'La fecha esperada para publicar a este foro es {$a}.';
$string['thisforumisdue'] = 'La fecha esperada para publicar a este foro era {$a}.';
$string['thisforumisthrottled'] = 'Este foro tiene un número limitado de mensajes para enviar en un cierto período de tiempo. El ajuste normalmente se hace en {$a->blockafter} mensaje(s) en {$a->blockperiod}';
$string['timed'] = 'Cronometrada';
$string['timeddiscussion'] = 'Discusión cronometrada';
$string['timedhidden'] = 'Estatus temporal: Oculto para estudiantes';
$string['timedposts'] = 'Mensajes con asignación de tiempo';
$string['timedvisible'] = 'Estatus temporal: Visible para todos los usuarios';
$string['timestartenderror'] = 'La fecha final no puede ser anterior a la inicial';
$string['togglediscussionmenu'] = 'Alternar el menú de la discusión';
$string['togglefullscreen'] = 'Alternar pantalla completa';
$string['togglesettingsdrawer'] = 'Alternar cajón de configuraciones';
$string['trackforum'] = 'Rastrear mensajes no leídos';
$string['tracking'] = 'Rastrear';
$string['trackingoff'] = 'Desactivado';
$string['trackingon'] = 'Forzado';
$string['trackingoptional'] = 'Opcional';
$string['trackingtype'] = 'Leer seguimiento';
$string['trackingtype_help'] = 'El monitoreo de lectura le permite a los participantes revisar rápidamente cuales publicaciones aun no han sido vistas al resaltar cualquier nueva publicación.

Si se configura a opcional, los participantes pueden elegir activar o desactivar el seguimiento mediante un enlace en el menú de acciones o el bloque de administración, dependiendo del tema (Los usuarios deben de tener también habilitado el seguimiento del foro en sus preferencias del foro).

Si se habilita el \'Permitir seguimiento de lectura forzado\' en la administración del sitio, entonces estará disponible una opción adicional - forzada. Esto significa que el seguimiento siempre está activado, sin importar las preferencias del foro del usuario.';
$string['trackreadposts_header'] = 'Rastreo del foro';
$string['unlockdiscussion'] = 'Des-bloquear esta discusión';
$string['unpindiscussion'] = 'Quitar fijación de esta discusión';
$string['unread'] = 'No leído';
$string['unreadpost'] = 'Publicación no leída';
$string['unreadposts'] = 'Mensajes no leídos';
$string['unreadpostsnumber'] = '{$a} mensaje(s) no leído(s)';
$string['unreadpostsone'] = '1 mensaje no leído';
$string['unsubscribe'] = 'Darse de baja de este foro';
$string['unsubscribeall'] = 'Dar de baja de todos los foros';
$string['unsubscribeallconfirm'] = 'Actualmente Usted está suscrito a  {$a->forums} foros y {$a->discussions} discusiones. ¿Realmente desea darse de baja de todos los foros y discusiones, y deshabilitar la suscripción automática a discusiones?';
$string['unsubscribeallconfirmdiscussions'] = 'Actualmente Usted está suscrito a {$a->discussions} discusiones. ¿Realmente desea darse de baja de todas las discusiones, y deshabilitar la suscripción automática a discusiones?';
$string['unsubscribeallconfirmforums'] = 'Actualmente Usted está suscrito a {$a->forums} foros. ¿Realmente desea darse de baja de todos los foros y deshabilitar la suscripción automática a discusiones?';
$string['unsubscribealldone'] = 'Se han eliminado todas sus suscripciones opcionales a los foros. Aun así, podría seguir recibiendo notificaciones de foros con suscripción forzosa. Si no desea recibir emails de este servidor, vaya por favor a su perfil y deshabilite allí la dirección email.';
$string['unsubscribeallempty'] = 'Usted no está suscrito a ningún foro. Si no desea recibir emails de este servidor, vaya por favor a su perfil y deshabilite allí la dirección email.';
$string['unsubscribed'] = 'No suscrito';
$string['unsubscribediscussion'] = 'Des-suscribirme de esta discusión';
$string['unsubscribediscussionlink'] = 'Des-suscribirse de esta discusión: {$a}';
$string['unsubscribelink'] = 'Des-suscribirse de este foro: {$a}';
$string['unsubscribeshort'] = 'Dar de baja (des-suscribir)';
$string['useexperimentalui'] = 'Usar vista de discusión anidada experimental';
$string['usermarksread'] = 'Calificado manual de lectura de mensajes';
$string['usernavigation'] = 'Navegación del usuario';
$string['usersforumposts'] = 'Publicaciones del foro del usuario';
$string['viewalldiscussions'] = 'Ver todas las discusiones';
$string['viewconversation'] = 'Ver discusión';
$string['viewgrades'] = 'Ver calificaciones';
$string['viewparentpost'] = 'Ver publicación paterna';
$string['viewthediscussion'] = 'Ver la discusión';
$string['warnafter'] = 'Umbral de mensajes para advertencia';
$string['warnafter_help'] = 'Se puede avisar a los estudiante de que se acercan al máximo número de aportaciones permitidas en el período de tiempo determinado. Este parámetro especifica después de cuántas aportaciones se les debe advertir. Los usuarios con la capacidad \'moodle/forum:postwitho están exentos de esta limitación.';
$string['warnformorepost'] = '¡Advertencia!. Hay más de una discusión en este foro - se usará la más reciente';
$string['yournewquestion'] = 'Su nueva pregunta';
$string['yournewtopic'] = 'Su nuevo tópico/tema de discusión';
$string['yourreply'] = 'Su respuesta (réplica)';
